///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

function FunctionSelector(eid)
{
   this.eid = eid;
}

FunctionSelector.prototype = new XUIEditor();

//-------------------
FunctionSelector.prototype.load = function()
{
   this.treePlaceholder = document.getElementById(this.eid + "TreePlaceholder");
   this.selectedExpr = document.getElementById(this.eid + "Syntax").innerHTML;

   if (this.treePlaceholder.innerHTML == "")
   {
      sawtree.addOnclickMethod("onClickFunction", FunctionSelector.onClickFunction)
      sawtree.addOndblclickMethod("onDblClickFunction", FunctionSelector.onDblClickFunction)
      var tTreeDef = '<xml>' + this.getTreeXML() + '</xml>';
      initSawTreeView(tTreeDef, this.treePlaceholder);
   }
}

//-------------------
FunctionSelector.prototype.apply = function()
{
   return true;
}

//-------------------
FunctionSelector.prototype.discard = function()
{
   this.parentEditor.discard();
}

//-------------------
FunctionSelector.prototype.getTreeXML = function()
{
   var strBuf = new saw.StringBuffer();
   strBuf.append("<request insertElementId='" + this.eid + "TreePlaceholder'></request><result><trees>");
   strBuf.append("<tree type='functionTree'><treeDef titleMsg='functionTree' id='functionTree' xmlns:saw='com.siebel.analytics.web/report/v1' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>");
   strBuf.append("<folderDef  imgExpand='treeview/minus.gif' img='treeview/plus.gif' ");
   strBuf.append("onClickMethodName='clickOnFolder' initClass='folderNormal' normalClass='folderNormal' overClass='folderOver' >");
   strBuf.append("<types><type type='catalog' name='folder'></type></types></folderDef>");
   strBuf.append("<leafDef><types><type type='catalog' name='function' onClickMethodName='onClickFunction' onDblClickMethodName='onDblClickFunction' img='treeview/dot.gif' selectable='true' initClass='nodeNormal' normalClass='nodeNormal' overClass='nodeOver'></type>");
   strBuf.append("</types></leafDef></treeDef>");

   strBuf.append("<treeData>");

   strBuf.append("<treeNode itemType='folder' displayName='" + this.escapequotes(kmsgFunctionSelectorFunctions) + "'>");
   strBuf.append("<treeBranch>");

   strBuf.append("<treeNode itemType='folder' displayName='" + this.escapequotes(kmsgFunctionSelectorGroupAggregate)  + "'>");
   strBuf.append("<customData><data name='initOpen' value='false'/></customData>");
   strBuf.append("<treeBranch>");
   this.getFunctionNodeXML(strBuf, "Avg", kmsgFunctionSelectorDescAvg, "Avg(expr)");
   this.getFunctionNodeXML(strBuf, "AvgDistinct", kmsgFunctionSelectorDescAvgDistinct, "Avg(DISTINCT expr)");
   this.getFunctionNodeXML(strBuf, "BottomN", kmsgFunctionSelectorDescBottomN, "BottomN(expr, integer)");
   this.getFunctionNodeXML(strBuf, "Count", kmsgFunctionSelectorDescCount, "COUNT(expr)");
   this.getFunctionNodeXML(strBuf, "CountDistinct", kmsgFunctionSelectorDescCountDistinct, "COUNT(DISTINCT expr)");
   this.getFunctionNodeXML(strBuf, "Count*", kmsgFunctionSelectorDescCountRows, "COUNT(*)");
   this.getFunctionNodeXML(strBuf, "Mavg", kmsgFunctionSelectorDescMavg, "MAVG(expr, integer)");
   this.getFunctionNodeXML(strBuf, "Max", kmsgFunctionSelectorDescMax, "MAX(expr)");
   this.getFunctionNodeXML(strBuf, "Median", kmsgFunctionSelectorDescMedian, "MEDIAN(expr)");
   this.getFunctionNodeXML(strBuf, "NTile", kmsgFunctionSelectorDescNTile, "NTILE(expr, numTiles)");
   this.getFunctionNodeXML(strBuf, "Min", kmsgFunctionSelectorDescMin, "MIN(expr)");
   this.getFunctionNodeXML(strBuf, "Percentile", kmsgFunctionSelectorDescPercentile, "PERCENTILE(expr)");
   this.getFunctionNodeXML(strBuf, "Rank", kmsgFunctionSelectorDescRank, "RANK(expr)");
   this.getFunctionNodeXML(strBuf, "StdDev", kmsgFunctionSelectorDescStdDev, "STDDEV(expr)");
   this.getFunctionNodeXML(strBuf, "StdDev_Pop", kmsgFunctionSelectorDescStdDevPop, "STDDEV_POP(expr)");
   this.getFunctionNodeXML(strBuf, "Sum", kmsgFunctionSelectorDescSum, "SUM(expr)");
   this.getFunctionNodeXML(strBuf, "SumDistinct", kmsgFunctionSelectorDescSumDistinct, "Sum(DISTINCT expr)");
   this.getFunctionNodeXML(strBuf, "TopN", kmsgFunctionSelectorDescTopN, "TOPN(expr, integer)");
   strBuf.append("</treeBranch>");
   strBuf.append("</treeNode>");

   strBuf.append("<treeNode itemType='folder' displayName='" + this.escapequotes(kmsgFunctionSelectorGroupRunningAggregate) + "'>");
   strBuf.append("<customData><data name='initOpen' value='false'/></customData>");
   strBuf.append("<treeBranch>");
   this.getFunctionNodeXML(strBuf, "MAVG", kmsgFunctionSelectorDescMAVG, "MAVG (expr, integer)");
   this.getFunctionNodeXML(strBuf, "MSUM", kmsgFunctionSelectorDescMSUM, "MSUM (expr, integer)");
   this.getFunctionNodeXML(strBuf, "RSUM", kmsgFunctionSelectorDescRSUM, "RSUM(expr)");
   this.getFunctionNodeXML(strBuf, "RCOUNT", kmsgFunctionSelectorDescRCOUNT, "RCOUNT(expr)");
   this.getFunctionNodeXML(strBuf, "RMAX", kmsgFunctionSelectorDescRMAX, "RMAX(expr)");
   this.getFunctionNodeXML(strBuf, "RMIN", kmsgFunctionSelectorDescRMIN, "RMIN(expr)");
   strBuf.append("</treeBranch>");
   strBuf.append("</treeNode>");

   strBuf.append("<treeNode itemType='folder' displayName='" + this.escapequotes(kmsgFunctionSelectorGroupString) + "'>");
   strBuf.append("<customData><data name='initOpen' value='false'/></customData>");
   strBuf.append("<treeBranch>");
   this.getFunctionNodeXML(strBuf, "ASCII", kmsgFunctionSelectorDescASCII, "ASCII(expr)");
   this.getFunctionNodeXML(strBuf, "Bit_Length", kmsgFunctionSelectorDescBitLength, "BIT_LENGTH(expr)");
   this.getFunctionNodeXML(strBuf, "Char", kmsgFunctionSelectorDescChar, "CHAR(expr)");
   this.getFunctionNodeXML(strBuf, "Char_Length", kmsgFunctionSelectorDescCharLength, "CHAR_LENGTH(expr)");
   this.getFunctionNodeXML(strBuf, "Concat", kmsgFunctionSelectorDescConcat, "CONCAT(expr1, expr2)");
   this.getFunctionNodeXML(strBuf, "Insert", kmsgFunctionSelectorDescInsert, "INSERT(expr1, integer1, integer2, expr2)");
   this.getFunctionNodeXML(strBuf, "Left", kmsgFunctionSelectorDescLeft, "LEFT(expr, integer)");
   this.getFunctionNodeXML(strBuf, "Length", kmsgFunctionSelectorDescLength, "LENGTH(expr)");
   this.getFunctionNodeXML(strBuf, "Locate", kmsgFunctionSelectorDescLocate, "LOCATE(expr1, expr2)");
   this.getFunctionNodeXML(strBuf, "LocateN", kmsgFunctionSelectorDescLocateN, "LOCATEN(expr1, expr2, integer)");
   this.getFunctionNodeXML(strBuf, "Lower", kmsgFunctionSelectorDescLower, "LOWER(expr)");
   this.getFunctionNodeXML(strBuf, "Octet_Length", kmsgFunctionSelectorDescOctetLength, "OCTET_LENGTH(expr)");
   this.getFunctionNodeXML(strBuf, "Position", kmsgFunctionSelectorDescPosition, "POSITION(expr1 IN expr2)");
   this.getFunctionNodeXML(strBuf, "Repeat", kmsgFunctionSelectorDescRepeat, "REPEAT(expr, integer)");
   this.getFunctionNodeXML(strBuf, "Replace", kmsgFunctionSelectorDescReplace, "REPLACE(expr1, expr2, expr3)");
   this.getFunctionNodeXML(strBuf, "Right", kmsgFunctionSelectorDescRight, "RIGHT(expr, integer)");
   this.getFunctionNodeXML(strBuf, "Space", kmsgFunctionSelectorDescSpace, "SPACE(expr)");
   this.getFunctionNodeXML(strBuf, "Substring", kmsgFunctionSelectorDescSubstring, "SUBSTRING(expr FROM startPos FOR length)");
   this.getFunctionNodeXML(strBuf, "TrimBoth", kmsgFunctionSelectorDescTrimBoth, "TRIM(BOTH char FROM expr)");
   this.getFunctionNodeXML(strBuf, "TrimLeading", kmsgFunctionSelectorDescTrimLeading, "TRIM(LEADING char FROM expr)");
   this.getFunctionNodeXML(strBuf, "TrimTrailing", kmsgFunctionSelectorDescTrimTrailing, "TRIM(TRAILING char FROM expr)");
   this.getFunctionNodeXML(strBuf, "Upper", kmsgFunctionSelectorDescUpper , "UPPER(expr)");
   strBuf.append("</treeBranch>");
   strBuf.append("</treeNode>");

   strBuf.append("<treeNode itemType='folder' displayName='" + this.escapequotes(kmsgFunctionSelectorGroupMath) + "'>");
   strBuf.append("<customData><data name='initOpen' value='false'/></customData>");
   strBuf.append("<treeBranch>");
   this.getFunctionNodeXML(strBuf, "Abs", kmsgFunctionSelectorDescAbs, "ABS(expr)");
   this.getFunctionNodeXML(strBuf, "Acos", kmsgFunctionSelectorDescAcos, "ACOS(expr)");
   this.getFunctionNodeXML(strBuf, "Asin", kmsgFunctionSelectorDescAsin, "ASIN(expr)");
   this.getFunctionNodeXML(strBuf, "Atan", kmsgFunctionSelectorDescAtan, "ATAN(expr)");
   this.getFunctionNodeXML(strBuf, "Atan2", kmsgFunctionSelectorDescAtan2, "ATAN2(expr1, expr2)");
   this.getFunctionNodeXML(strBuf, "Ceiling", kmsgFunctionSelectorDescCeiling, "CEILING(expr)");
   this.getFunctionNodeXML(strBuf, "Cos", kmsgFunctionSelectorDescCos, "COS(expr)");
   this.getFunctionNodeXML(strBuf, "Cot", kmsgFunctionSelectorDescCot, "COT(expr)");
   this.getFunctionNodeXML(strBuf, "Degrees", kmsgFunctionSelectorDescDegrees, "DEGREES(expr)");
   this.getFunctionNodeXML(strBuf, "Exp", kmsgFunctionSelectorDescExp, "EXP(expr)");
   this.getFunctionNodeXML(strBuf, "Floor", kmsgFunctionSelectorDescFloor, "FLOOR(expr)");
   this.getFunctionNodeXML(strBuf, "Log", kmsgFunctionSelectorDescLog, "LOG(expr)");
   this.getFunctionNodeXML(strBuf, "Log10", kmsgFunctionSelectorDescLog10, "LOG10(expr)");
   this.getFunctionNodeXML(strBuf, "Mod", kmsgFunctionSelectorDescMod, "MOD(expr1, expr2)");
   this.getFunctionNodeXML(strBuf, "Pi", kmsgFunctionSelectorDescPi, "PI()");
   this.getFunctionNodeXML(strBuf, "Power", kmsgFunctionSelectorDescPower, "POWER(expr1, expr2)");
   this.getFunctionNodeXML(strBuf, "Radians", kmsgFunctionSelectorDescRadians, "RADIANS(expr)");
   this.getFunctionNodeXML(strBuf, "Rand", kmsgFunctionSelectorDescRand, "RAND()");
   this.getFunctionNodeXML(strBuf, "RandFromSeed", kmsgFunctionSelectorDescRandFromSeed, "RAND(expr)");
   this.getFunctionNodeXML(strBuf, "Round", kmsgFunctionSelectorDescRound, "ROUND(expr, integer)");
   this.getFunctionNodeXML(strBuf, "Sign", kmsgFunctionSelectorDescSign , "SIGN(expr)");
   this.getFunctionNodeXML(strBuf, "Sin", kmsgFunctionSelectorDescSin, "SIN(expr)");
   this.getFunctionNodeXML(strBuf, "Sqrt", kmsgFunctionSelectorDescSqrt, "SQRT(expr)");
   this.getFunctionNodeXML(strBuf, "Tan", kmsgFunctionSelectorDescTan, "TAN(expr)");
   this.getFunctionNodeXML(strBuf, "Truncate", kmsgFunctionSelectorDescTruncate, "TRUNCATE(expr, integer)");
   strBuf.append("</treeBranch>");
   strBuf.append("</treeNode>");

   strBuf.append("<treeNode itemType='folder' displayName='" + this.escapequotes(kmsgFunctionSelectorGroupCalendar) + "'>");
   strBuf.append("<customData><data name='initOpen' value='false'/></customData>");
   strBuf.append("<treeBranch>");
   this.getFunctionNodeXML(strBuf, "Current_Date", kmsgFunctionSelectorDescCurrentDate, "CURRENT_DATE");
   this.getFunctionNodeXML(strBuf, "Current_Time", kmsgFunctionSelectorDescCurrentTime, "CURRENT_TIME(expr)");
   this.getFunctionNodeXML(strBuf, "Current_TimeStamp", kmsgFunctionSelectorDescCurrentTimeStamp, "CURRENT_TIMESTAMP(expr)");
   this.getFunctionNodeXML(strBuf, "Day_of_Quarter", kmsgFunctionSelectorDescDayOfQuarter, "DAY_OF_QUARTER(expr)");
   this.getFunctionNodeXML(strBuf, "DayName", kmsgFunctionSelectorDescDayName, "DAYNAME(expr)");
   this.getFunctionNodeXML(strBuf, "DayOfMonth", kmsgFunctionSelectorDescDayOfMonth, "DAYOFMONTH(expr)");
   this.getFunctionNodeXML(strBuf, "DayOfWeek", kmsgFunctionSelectorDescDayOfWeek, "DAYOFWEEK(expr)");
   this.getFunctionNodeXML(strBuf, "DayOfYear", kmsgFunctionSelectorDescDayOfYear, "DAYOFYEAR(expr)");
   this.getFunctionNodeXML(strBuf, "Hour", kmsgFunctionSelectorDescHour, "HOUR(expr)");
   this.getFunctionNodeXML(strBuf, "Minute", kmsgFunctionSelectorDescMinute, "MINUTE(expr)");
   this.getFunctionNodeXML(strBuf, "Month", kmsgFunctionSelectorDescMonth, "MONTH(expr)");
   this.getFunctionNodeXML(strBuf, "Month_Of_Quarter", kmsgFunctionSelectorDescMonthOfQuarter, "MONTH_OF_QUARTER(expr)");
   this.getFunctionNodeXML(strBuf, "MonthName", kmsgFunctionSelectorDescMonthName, "MONTHNAME(expr)");
   this.getFunctionNodeXML(strBuf, "Now", kmsgFunctionSelectorDescNow, "NOW()");
   this.getFunctionNodeXML(strBuf, "Quarter_Of_Year", kmsgFunctionSelectorDescQuarterOfYear, "QUARTER_OF_YEAR(expr)");
   this.getFunctionNodeXML(strBuf, "Second", kmsgFunctionSelectorDescSecond, "SECOND(expr)");
   this.getFunctionNodeXML(strBuf, "TimestampAdd", kmsgFunctionSelectorDescTimestampAdd, "TIMESTAMPADD(interval, expr, timestamp)");
   this.getFunctionNodeXML(strBuf, "TimestampDiff", kmsgFunctionSelectorDescTimestampDiff, "TIMESTAMPDIFF(interval, expr, timestamp2)");
   this.getFunctionNodeXML(strBuf, "Week_Of_Quarter", kmsgFunctionSelectorDescWeekOfQuarter, "WEEK_OF_QUARTER(expr)");
   this.getFunctionNodeXML(strBuf, "Week_Of_Year", kmsgFunctionSelectorDescWeekOfYear, "WEEK_OF_YEAR(expr)");
   this.getFunctionNodeXML(strBuf, "Year", kmsgFunctionSelectorDescYear, "YEAR(expr)");
   strBuf.append("</treeBranch>");
   strBuf.append("</treeNode>");

   strBuf.append("<treeNode itemType='folder' displayName='" + this.escapequotes(kmsgFunctionSelectorGroupConversion) + "'>");
   strBuf.append("<customData><data name='initOpen' value='false'/></customData>");
   strBuf.append("<treeBranch>");
   this.getFunctionNodeXML(strBuf, "Cast", kmsgFunctionSelectorDescCast, "CAST(expr AS type)");
   this.getFunctionNodeXML(strBuf, "IfNull", kmsgFunctionSelectorDescIfNull, "IFNULL(expr, value)");
   this.getFunctionNodeXML(strBuf, "ValueOf", kmsgFunctionSelectorDescValueOf, "VALUEOF(expr)");
   strBuf.append("</treeBranch>");
   strBuf.append("</treeNode>");

   strBuf.append("<treeNode itemType='folder' displayName='" + this.escapequotes(kmsgFunctionSelectorGroupSystem) + "'>");
   strBuf.append("<customData><data name='initOpen' value='false'/></customData>");
   strBuf.append("<treeBranch>");
   this.getFunctionNodeXML(strBuf, "User", kmsgFunctionSelectorDescUser, "USER()");
   this.getFunctionNodeXML(strBuf, "Database", kmsgFunctionSelectorDescDatabase, "DATABASE()");
   strBuf.append("</treeBranch>");
   strBuf.append("</treeNode>");

   strBuf.append("<treeNode itemType='folder' displayName='" + this.escapequotes(kmsgFunctionSelectorGroupExpressions) + "'>");
   strBuf.append("<customData><data name='initOpen' value='false'/></customData>");
   strBuf.append("<treeBranch>");
   this.getFunctionNodeXML(strBuf, "Case (Switch)", kmsgFunctionSelectorDescCaseSwitch, "CASE expr1 WHEN expr2 THEN expr3 ELSE expr4 END");
   this.getFunctionNodeXML(strBuf, "Case (If)", kmsgFunctionSelectorDescCaseIf, "CASE WHEN request_condition1 THEN expr1 ELSE expr2 END");
   strBuf.append("</treeBranch>");
   strBuf.append("</treeNode>");

   strBuf.append("</treeBranch>");
   strBuf.append("</treeNode>");

   strBuf.append("</treeData>");
   strBuf.append("</tree></trees></result>");

   return strBuf.toString();
}

//-------------------
FunctionSelector.prototype.getFunctionNodeXML = function(strBuf, sName, sHelpText, sExpr)
{
   strBuf.append("<treeNode itemType='item' displayName='");
   sName += '&#x200E;';
   strBuf.append(this.escapequotes(sName));
   strBuf.append("' signature='function'>");
   strBuf.append("<customData><data name='expr' value='");
   strBuf.append(sExpr);
   strBuf.append("'/></customData>");
   strBuf.append("<customData><data name='helpText' value='");
   strBuf.append(this.escapequotes(sHelpText));
   strBuf.append("'/></customData></treeNode>");
}

/********************************************************************************************/
FunctionSelector.prototype.escapequotes = function (sorig) 
{ 
   var tRE = new RegExp("'","g");
   return sorig.replace(tRE, "&apos;");
}

/********************************************************************************************/
FunctionSelector.onClickFunction = function (functionId, event) 
{ 
   var clicked = sawtree.findItem(functionId);
   sawtree.selectItem(functionId, clicked.getPath());

   var sElement = window.saw.getEventTarget(event);

   var tEditor = XUIPanel.getEditor('idFunctionSelector');
   tEditor.selectedExpr = clicked.expr;

   document.getElementById(tEditor.eid + "Name").innerHTML = clicked.displayName;
   document.getElementById(tEditor.eid + "Syntax").innerHTML = clicked.expr;
   document.getElementById(tEditor.eid + "HelpText").innerHTML = clicked.helpText;
}

/********************************************************************************************/
FunctionSelector.onDblClickFunction = function (functionId, event) 
{ 
   // simulate OK if double-click on a function
   var tEditor = XUIPanel.getEditor('idFunctionSelector');
   XUIDialog.ok(tEditor.eid);
}
